/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.formatter;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.formatter.NodeFormatterContext;
import icyllis.flexmark.util.ast.BlankLine;
import icyllis.flexmark.util.ast.BlockQuoteLike;
import icyllis.flexmark.util.ast.Document;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.format.MarkdownWriterBase;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.builder.SequenceBuilder;

public class MarkdownWriter
extends MarkdownWriterBase<MarkdownWriter, Node, NodeFormatterContext> {
    public MarkdownWriter() {
        this(null, 0);
    }

    public MarkdownWriter(int formatOptions) {
        this(null, formatOptions);
    }

    public MarkdownWriter(@Nullable Appendable appendable, int formatOptions) {
        super(appendable, formatOptions);
    }

    @Override
    @NotNull
    public MarkdownWriter getEmptyAppendable() {
        return new MarkdownWriter(this.appendable, this.appendable.getOptions());
    }

    @Override
    @NotNull
    public BasedSequence lastBlockQuoteChildPrefix(BasedSequence prefix) {
        Node parent;
        Node node = (Node)((NodeFormatterContext)this.context).getCurrentNode();
        while (node != null && node.getNextAnyNot(BlankLine.class) == null && (parent = node.getParent()) != null && !(parent instanceof Document)) {
            int pos;
            if (parent instanceof BlockQuoteLike && (pos = prefix.lastIndexOfAny(((NodeFormatterContext)this.context).getBlockQuoteLikePrefixPredicate())) >= 0) {
                prefix = ((SequenceBuilder)((SequenceBuilder)prefix.getBuilder().append(prefix.subSequence(0, pos))).append(' ').append((CharSequence)prefix.subSequence(pos + 1))).toSequence();
            }
            node = parent;
        }
        return prefix;
    }

    @NotNull
    public MarkdownWriter appendNonTranslating(@NotNull CharSequence csq) {
        return this.appendNonTranslating(null, csq, null, null);
    }

    @NotNull
    public MarkdownWriter appendNonTranslating(@Nullable CharSequence prefix, @NotNull CharSequence csq) {
        return this.appendNonTranslating(prefix, csq, null, null);
    }

    @NotNull
    public MarkdownWriter appendNonTranslating(@Nullable CharSequence prefix, @NotNull CharSequence csq, @Nullable CharSequence suffix) {
        return this.appendNonTranslating(prefix, csq, suffix, null);
    }

    @NotNull
    public MarkdownWriter appendNonTranslating(@Nullable CharSequence prefix, @NotNull CharSequence csq, @Nullable CharSequence suffix, @Nullable CharSequence suffix2) {
        if (((NodeFormatterContext)this.context).isTransformingText()) {
            this.append(((NodeFormatterContext)this.context).transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    @NotNull
    public MarkdownWriter appendTranslating(@NotNull CharSequence csq) {
        return this.appendTranslating(null, csq, null, null);
    }

    @NotNull
    public MarkdownWriter appendTranslating(@Nullable CharSequence prefix, @NotNull CharSequence csq) {
        return this.appendTranslating(prefix, csq, null, null);
    }

    @NotNull
    public MarkdownWriter appendTranslating(@Nullable CharSequence prefix, @NotNull CharSequence csq, @Nullable CharSequence suffix) {
        return this.appendTranslating(prefix, csq, suffix, null);
    }

    @NotNull
    public MarkdownWriter appendTranslating(@Nullable CharSequence prefix, @NotNull CharSequence csq, @Nullable CharSequence suffix, @Nullable CharSequence suffix2) {
        if (((NodeFormatterContext)this.context).isTransformingText()) {
            this.append(((NodeFormatterContext)this.context).transformTranslating(prefix, csq, suffix, suffix2));
        } else {
            if (prefix != null) {
                this.append(prefix);
            }
            this.append(csq);
            if (suffix != null) {
                this.append(suffix);
            }
            if (suffix2 != null) {
                this.append(suffix2);
            }
        }
        return this;
    }
}

